<!-- Most of the work designers do will be on themes in the (Now) Next 1-3 milestone column of their UX Roadmap. These themes are comprised of high-confidence outcomes and validated needs. The UX theme issue is where collaboration should occur, including plans and discussion on subthemes, research, and design feedback. Related design exploration and solution validation issues should stem from the theme issue. 

One of the advantages of working with UX themes is that it allows us to think and design holistically by designing the theme as a whole instead of a single issue at a time, trying to piece them together as we go. For more details, please refer to this section of the handbook when creating UX Themes: https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#ux-theme-structure -->

<!--
!!Note: The theme statement is the defacto title that will reference the theme and serve as the theme issue title.!! It should be something that is easily understood that quickly communicates the intent of the theme allowing team members to easily understand and recognize the expected work that will be done.
-->

----

### Theme statement
<!-- A theme statement combines the beneficiary, their job, and their expected outcome when the work is delivered and serves as the design goal for the team who owns the theme. Well-defined statements are concise without sacrificing the substance of the theme so that anyone can understand it at a glance. Well-defined statements are concise without sacrificing the substance of the theme so that anyone can understand it at a glance. (For instance, Reduce the effort for security teams when prioritizing business-critical risks in their assets.) -->

<!-- Also Theme issue tile -->
{`Need/outcome` } + {`Beneficiary`} + {`Job/Small Job`} 

#### Main Job story
<!-- What is the [Main Job story](https://about.gitlab.com/handbook/product/ux/jobs-to-be-done/#how-to-write-a-jtbd) that this theme was derived from? (For instance, When I am on triage rotation, I want to address all the business-critical risks in my assets, So I can minimize the likelihood of my organization being compromised by a security breach.) -->


#### Business objective
<!-- Objectives (from a business point of view) that will be achieved upon completion. (For instance, Increase engagement by making the experience efficient while reducing the chances of users overlooking high-priority items. --> 


#### Confidence
<!-- How well do we understand the user's problem and their need? Refer to https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#confidence to assess confidence -->


| Confidence | Research | 
| --- | --- | 
| [High/Medium/Low] | [research/insight issue](Link) | 


### Requirements
<!-- Requirements can be taken from existing features or design issues used to build this theme. Any related issues should be linked with this issue in the Feature/solution issues section below. They are more granular validated needs, goals, and additional details that the theme encompasses. These are typically reserved for themes in the next (1-3 milestones) column. Requirements should answer “what” the beneficiary of this theme needs from the solution.

Note: This is not a backlog. If the issue can not be delivered in the theme timeframe, then the theme is too big and needs to be broken down into multiple themes. -->

>⚠️ Related feature and research issues should be linked in the related issues section (Delete this line when this is done)

#### The beneficiary needs to be able to:
- [Small job statement]
  - [Micro job statement]
  - [Micro job statement]
- [etc.]

#### Research
<!-- Researchers and Designers; Use this table to track UX research related to this theme. This may include problem validation and solution validation activities. 
--> 

| Issue | Research type | Research status |
| ---------- | --------- | --------- |   
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |  
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |

#### Ready for design checklist
The items are self-check suggestions; they could be contributed by designers, product managers, or researchers
* [ ] The `theme` has high confidence (derived from research or other data-gathering techniques)
* [ ] The `Related issues`, features, research, and other background information are linked to the related issues section
* [ ] The `Business objective` has been defined
* [ ] The `Requirements` have been defined, and the scope has been agreed upon
* [ ] This UX Theme contains everything necessary to complete a design solution and is ready for design

#### [Thematic design workflow checklist](https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#suggested-workflow)
<!-- please refer to the [suggested workflow](https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#suggested-workflow) when working on UX themes-->
* [ ] **Theme assessed** Ready for design checklist complete
* [ ] **Ideate and Iterate**
  * [ ] User flow diagram generated
  * [ ] Low-fidelity wireframes of the entire theme created
  * [ ] [Feedback requested](https://about.gitlab.com/handbook/product/ux/product-designer/#design-reviews) and incorporated into flow diagram and wireframes
* [ ] **Validate**
  * [ ] [Solution validation](https://about.gitlab.com/handbook/product/ux/ux-research/solution-validation-and-methods/) conducted on Low/mid-fidelity flow 
* [ ] **Refine**  
  * [ ] Resaerch findings incorporated into design
  * [ ] All micro-interactions are defined
  * [ ] All edge-cases are accounted for and defined
  * [ ] All copy has been reviewed by tech writing
  * [ ] Accessibnility guidelines have been considered
  * [ ] High-fidelity designs posted
  * [ ] Feedback requested from counterparts
    * [ ] (If necessary) Validate high-fidelity flow in a 2nd round of user testing
  * [ ] Refine final design from feedback and user research
* [ ] **Hand-off**
  * [ ] Designs broken down based on the their ability to stand alone and that they provide value to the user.
  * [ ] MVC plan agreement reached 
  * [ ] Planning breakdown complete

/label ~"UX"  ~"UX Theme"
